/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.old.views;

import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.old.views.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class OptionsToolBar {
    public static final int FLAT_VIEW = 0;
    public static final int TREE_VIEW = 1;
    private ToolBar fOptionsBar;
    private ToolItem fDropdown;
    private MenuItem fFlatView;
    private MenuItem fTreeView;
    private MenuItem fShowDates;
    private Client fClient;

    public OptionsToolBar(Composite parent, Client client) {
        this.fOptionsBar = this.createContents(parent);
        this.fClient = client;
    }

    public int getPresentationType() {
        if (this.fTreeView.getSelection()) {
            return 1;
        }
        return 0;
    }

    public void setPresentationType(int type) {
        if (type == 0) {
            this.fFlatView.setSelection(true);
        } else if (type == 1) {
            this.fTreeView.setSelection(true);
        }
    }

    public void setShowDatesSelected(boolean selected) {
        this.fShowDates.setSelection(selected);
    }

    public void setEnabled(boolean enabled) {
        if (!this.fOptionsBar.isDisposed()) {
            this.fOptionsBar.setEnabled(enabled);
        }
    }

    private ToolBar createContents(final Composite parent) {
        final ToolBar optionsBar = new ToolBar(parent, 0x800000);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionsBar.setLayout((Layout)layout);
        this.fDropdown = new ToolItem(optionsBar, 4);
        this.fDropdown.setToolTipText(Messages.SmartSyncDialog_OptionsToolTip);
        this.fDropdown.setImage(SyncingUIPlugin.getImage("icons/full/obj16/configure.gif"));
        final Menu menu = new Menu((Control)optionsBar);
        this.fDropdown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = optionsBar.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = parent.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        this.fFlatView = new MenuItem(menu, 16);
        this.fFlatView.setText(Messages.SmartSyncDialog_FlatView);
        this.fFlatView.setImage(SyncingUIPlugin.getImage("icons/full/obj16/flatView.gif"));
        SelectionAdapter refreshAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsToolBar.this.fClient.stateChanged(OptionsToolBar.this.getPresentationType());
            }
        };
        this.fFlatView.addSelectionListener((SelectionListener)refreshAdapter);
        this.fTreeView = new MenuItem(menu, 16);
        this.fTreeView.setText(Messages.SmartSyncDialog_TreeView);
        this.fTreeView.setImage(SyncingUIPlugin.getImage("icons/full/obj16/treeView.gif"));
        this.fTreeView.addSelectionListener((SelectionListener)refreshAdapter);
        this.fShowDates = new MenuItem(menu, 32);
        this.fShowDates.setText(Messages.SmartSyncDialog_ShowDates);
        this.fShowDates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsToolBar.this.fClient.showDatesSelected(OptionsToolBar.this.fShowDates.getSelection());
            }
        });
        return optionsBar;
    }

    public static interface Client {
        public void stateChanged(int var1);

        public void showDatesSelected(boolean var1);
    }
}

